/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.LinkLayerCompTest;

import com.quantumdata.LinkLayerCompTest.DPBasePanel;
import com.quantumdata.LinkLayerCompTest.llctGui;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class DPPreferredTimingPanel
extends QDPanel {
    private static final long serialVersionUID = 589499300211L;
    private JTextField aHorizontalResolution;
    private JTextField aVerticalResolution;
    private JTextField aRefreshRate;
    private JComboBox aFormat;
    private JComboBox aBlankingMode;
    private JComboBox aMaxBitsPerComponent;
    private llctGui mainWin;

    public DPPreferredTimingPanel(llctGui llctGui2) {
        this.mainWin = llctGui2;
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Device Preferred Timing"));
        this.aHorizontalResolution = new JTextField(8);
        this.aVerticalResolution = new JTextField(8);
        this.aRefreshRate = new JTextField(8);
        this.aFormat = new JComboBox();
        this.aFormat.addItem("Interlaced");
        this.aFormat.addItem("Progressive");
        this.aBlankingMode = new JComboBox();
        this.aBlankingMode.addItem("Reduced");
        this.aBlankingMode.addItem("Normal");
        this.aMaxBitsPerComponent = new JComboBox();
        this.aMaxBitsPerComponent.addItem("6");
        this.aMaxBitsPerComponent.addItem("8");
        this.aMaxBitsPerComponent.addItem("10");
        this.aMaxBitsPerComponent.addItem("12");
        this.aMaxBitsPerComponent.addItem("16");
        int n = 0;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        QDPanel qDPanel = new QDPanel(gridBagLayout);
        QDLabel qDLabel = new QDLabel("Resolution (Horizontal):");
        gridBagConstraints = DPBasePanel.createGridBagConstraints(1, 0, n, 3, 22);
        gridBagLayout.setConstraints(qDLabel, gridBagConstraints);
        qDPanel.add(qDLabel);
        gridBagConstraints = DPBasePanel.createGridBagConstraints(1, 1, n++, 3, 21);
        gridBagLayout.setConstraints(this.aHorizontalResolution, gridBagConstraints);
        qDPanel.add(this.aHorizontalResolution);
        QDLabel qDLabel2 = new QDLabel("Resolution (Vertical):");
        gridBagConstraints = DPBasePanel.createGridBagConstraints(1, 0, n, 3, 22);
        gridBagLayout.setConstraints(qDLabel2, gridBagConstraints);
        qDPanel.add(qDLabel2);
        gridBagConstraints = DPBasePanel.createGridBagConstraints(1, 1, n++, 3, 21);
        gridBagLayout.setConstraints(this.aVerticalResolution, gridBagConstraints);
        qDPanel.add(this.aVerticalResolution);
        QDLabel qDLabel3 = new QDLabel("Refresh Rate (Hz):");
        gridBagConstraints = DPBasePanel.createGridBagConstraints(1, 0, n, 3, 22);
        gridBagLayout.setConstraints(qDLabel3, gridBagConstraints);
        qDPanel.add(qDLabel3);
        gridBagConstraints = DPBasePanel.createGridBagConstraints(1, 1, n++, 3, 22);
        gridBagLayout.setConstraints(this.aRefreshRate, gridBagConstraints);
        qDPanel.add(this.aRefreshRate);
        QDLabel qDLabel4 = new QDLabel("TV Format:");
        gridBagConstraints = DPBasePanel.createGridBagConstraints(1, 0, n, 3, 22);
        gridBagLayout.setConstraints(qDLabel4, gridBagConstraints);
        qDPanel.add(qDLabel4);
        gridBagConstraints = DPBasePanel.createGridBagConstraints(1, 1, n++, 3, 21);
        gridBagLayout.setConstraints(this.aFormat, gridBagConstraints);
        qDPanel.add(this.aFormat);
        QDLabel qDLabel5 = new QDLabel("Blanking Mode:");
        gridBagConstraints = DPBasePanel.createGridBagConstraints(1, 0, n, 3, 22);
        gridBagLayout.setConstraints(qDLabel5, gridBagConstraints);
        qDPanel.add(qDLabel5);
        gridBagConstraints = DPBasePanel.createGridBagConstraints(1, 1, n++, 3, 21);
        gridBagLayout.setConstraints(this.aBlankingMode, gridBagConstraints);
        qDPanel.add(this.aBlankingMode);
        this.add((Component)qDPanel, "Center");
        QDLabel qDLabel6 = new QDLabel("Max Bits Per Component:");
        gridBagConstraints = DPBasePanel.createGridBagConstraints(1, 0, n, 3, 22);
        gridBagLayout.setConstraints(qDLabel6, gridBagConstraints);
        qDPanel.add(qDLabel6);
        gridBagConstraints = DPBasePanel.createGridBagConstraints(1, 1, n++, 3, 21);
        gridBagLayout.setConstraints(this.aMaxBitsPerComponent, gridBagConstraints);
        qDPanel.add(this.aMaxBitsPerComponent);
        this.add((Component)qDPanel, "Center");
    }

    public int GetHorizontalResolution() {
        int n = 0;
        try {
            n = new Integer(this.aHorizontalResolution.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public int GetVerticalResolution() {
        int n = 0;
        try {
            n = new Integer(this.aVerticalResolution.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public int GetRefreshRate() {
        int n = 0;
        try {
            n = new Integer(this.aRefreshRate.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public String GetFormat() {
        String string = (String)this.aFormat.getSelectedItem();
        return string;
    }

    public String GetBlankingMode() {
        String string = (String)this.aBlankingMode.getSelectedItem();
        return string;
    }

    public int GetMaximumBitsPerComponent() {
        int n = 6;
        String string = (String)this.aMaxBitsPerComponent.getSelectedItem();
        n = new Integer(string);
        return n;
    }

    public void reset() {
        this.aHorizontalResolution.setText("");
        this.aVerticalResolution.setText("");
        this.aRefreshRate.setText("");
        this.aFormat.setSelectedIndex(0);
        this.aBlankingMode.setSelectedIndex(0);
        this.aMaxBitsPerComponent.setSelectedIndex(0);
    }

    public void renderInactive() {
        this.reset();
        this.aHorizontalResolution.setEnabled(false);
        this.aVerticalResolution.setEnabled(false);
        this.aRefreshRate.setEnabled(false);
        this.aFormat.setEnabled(false);
        this.aBlankingMode.setEnabled(false);
    }

    public void UpdateStatus(String string) {
        int n = 0;
        try {
            int n2 = this.mainWin.getInt(string + ":llhf?");
            this.aHorizontalResolution.setText(Integer.toString(n2));
            System.out.println(this.aHorizontalResolution.getText());
            n2 = this.mainWin.getInt(string + ":llvf?");
            this.aVerticalResolution.setText(Integer.toString(n2));
            n2 = this.mainWin.getInt(string + ":llrf?");
            this.aRefreshRate.setText(Integer.toString(n2));
            n2 = this.mainWin.getInt(string + ":lltf?");
            this.aFormat.setSelectedIndex(n2);
            n2 = this.mainWin.getInt(string + ":llbf?");
            this.aBlankingMode.setSelectedIndex(n2);
            n = this.mainWin.getInt(string + ":llmc?");
            for (int i = 0; i < this.aMaxBitsPerComponent.getItemCount(); ++i) {
                if (n != Integer.parseInt((String)this.aMaxBitsPerComponent.getItemAt(i))) continue;
                this.aMaxBitsPerComponent.setSelectedIndex(i);
                break;
            }
        }
        catch (InstrumentException instrumentException) {
            System.out.println(instrumentException.toString());
        }
    }

    public void SendBackStatus(String string) {
        try {
            this.mainWin.sendCmd(string + ":llhf " + this.aHorizontalResolution.getText());
            System.out.println(this.aHorizontalResolution.getText());
            this.mainWin.sendCmd(string + ":llvf " + this.aVerticalResolution.getText());
            this.mainWin.sendCmd(string + ":llrf " + this.aRefreshRate.getText());
            if (this.aFormat.getSelectedItem() == "Interlaced") {
                this.mainWin.sendCmd(string + ":lltf " + "0");
            } else {
                this.mainWin.sendCmd(string + ":lltf " + "1");
            }
            if (this.aBlankingMode.getSelectedItem() == "Reduced") {
                this.mainWin.sendCmd(string + ":llbf " + "0");
            } else {
                this.mainWin.sendCmd(string + ":llbf " + "1");
            }
            this.mainWin.sendCmd(string + ":llmc " + (String)this.aMaxBitsPerComponent.getSelectedItem());
        }
        catch (InstrumentException instrumentException) {
            System.out.println(instrumentException.toString());
        }
    }
}

